program Housenka;

//vytvoreno jako pomucka k reseni KSI 2012/2013: uloha 3-4 "Taxonomie haveti"
//27.12.2012, Jan Horacek
//v1.0

{$APPTYPE CONSOLE}

uses
  SysUtils;

const
  _MAX_CHILD = 16;
  _MAX_VRCHOL = 16;
  _MAX_STROM  = $FFFFFF;
  IMAGE_FILE_LARGE_ADDRESS_AWARE = $0020;

  _T_HOUSENKA = 1;
  _T_HUMR     = 2;

{$SetPEFlags IMAGE_FILE_LARGE_ADDRESS_AWARE}

type
  PTVrchol = ^TVrchol;
  TVrchol = record
   Childs:record
    Count:Integer;
    Data:array [0.._MAX_CHILD] of PTVrchol;
   end;
  end;//TVrchol

  PTStrom = ^TStrom;
  TStrom = record
   Vrcholy:record
    Count:Integer;
    Data:array [0.._MAX_VRCHOL] of PTVrchol;
   end;
  end;//TStrom

  TStromy = record
   Count:Integer;
   Data:array [0.._MAX_STROM] of PTStrom;
  end;

var
  Stromy:TStromy;
  l:Integer;
  vrch_cnt:Integer;
  return:boolean;
  cnt_hous,cnt_humr:Integer;

////////////////////////////////////////////////////////////////////////////////
//Funkce na generovani stromu:

//vytvoreni 0. stromu
//tento stroma ma 2 navzajem propojene vrcholy
procedure Initialize();
begin
 //vlozime 2 vrcholy do 0. stromu
 Stromy.Count := 1;

 GetMem(Stromy.Data[0],SizeOf(Stromy.Data[0]));
 with (Stromy.Data[0]^) do
  begin
   Vrcholy.Count := 2;
   New(Vrcholy.Data[0]);
   New(Vrcholy.Data[1]);

   Vrcholy.Data[0]^.Childs.Count := 1;
   Vrcholy.Data[1]^.Childs.Count := 1;

   Vrcholy.Data[0]^.Childs.Data[0] := Vrcholy.Data[1];
   Vrcholy.Data[1]^.Childs.Data[0] := Vrcholy.Data[0];
  end;//with
end;//procedure

//delete all data from memory
procedure FreeData();
var i,j:Integer;
begin
 for i := 0 to Stromy.Count-1 do
  begin
   for j := 0 to Stromy.Data[i]^.Vrcholy.Count-1 do Dispose(Stromy.Data[i]^.Vrcholy.Data[j]);
   Dispose(Stromy.Data[i]);
   Stromy.Data[i] := nil;
  end;//for i
end;//procedure

//delete 1 tree
procedure FreeStrom(strom:integer);
var i:Integer;
begin
 for i := 0 to Stromy.Data[strom]^.Vrcholy.Count-1 do Dispose(Stromy.Data[strom]^.Vrcholy.Data[i]);
 Dispose(Stromy.Data[strom]);
 Stromy.Data[strom] := nil;
end;//procedure

//prevede ukazatele na deti v puvodnim stromu na ukazatele na deti v cilovem stromu
//tady se predpoklada, ze deti jsou pouze v danem stromu, jinak se nezkopiruji
//tady je zapotrebi, aby vsechny vrcholy uz byly vytvoreny
procedure CopyChilds(src:integer;dest:integer;vrchol:integer);
var i,j:Integer;
    copied:boolean;
begin
 Stromy.Data[dest]^.Vrcholy.Data[vrchol]^.Childs.Count := Stromy.Data[src]^.Vrcholy.Data[vrchol]^.Childs.Count;
 for i := 0 to Stromy.Data[src]^.Vrcholy.Data[vrchol]^.Childs.Count-1 do
  begin
   copied := false;

   //hledame, na jaky index v poli vrcholu vede pointer child[i]
   for j := 0 to Stromy.Data[src]^.Vrcholy.Count-1 do
    begin
     if (Stromy.Data[src]^.Vrcholy.Data[vrchol]^.Childs.Data[i] = Stromy.Data[src]^.Vrcholy.Data[j]) then
      begin
       Stromy.Data[dest]^.Vrcholy.Data[vrchol]^.Childs.Data[i] := Stromy.Data[dest]^.Vrcholy.Data[j];
       copied := true;
       Break;
      end;
    end;//for j

   if (not copied) then writeln('COPY ERROR: child pointer not copied');
  end;//for i
end;

//okopiruje cely strom ze source a prida ho na konc pole
//kma ho pridalo, to vrati v dest
function CopyStrom(src:integer; var dest:integer):Byte;
var i:Integer;
begin
 if (src >= Stromy.Count) then
  begin
   Result := 1;
   writeln('COPY: src > Stromy.Count');
   Exit;
  end;
 if (Stromy.Count >= _MAX_STROM) then
  begin
   Result := 2;
   writeln('COPY: prekrocen maximalni pocet stromu');
   Exit;
  end;

 //pridani dalsiho stromu identickeho s src
 dest := Stromy.Count;
 Stromy.Count := Stromy.Count + 1;
 New(Stromy.Data[dest]);

 //nejdriv vytvorime vsechny vrcholy
 Stromy.Data[dest]^.Vrcholy.Count := Stromy.Data[src]^.Vrcholy.Count;
 for i := 0 to Stromy.Data[src]^.Vrcholy.Count-1 do New(Stromy.Data[dest]^.Vrcholy.Data[i]);

 //a pak navezeme vazby deti
 for i := 0 to Stromy.Data[src]^.Vrcholy.Count-1 do CopyChilds(src,dest,i);

 Result := 0;
end;//procedure

//prida na kazdy mozny vrchol (resp. na vsechny vrcholy) dalsi vrchol a navaze ho na nej
//vytvorene stromy prida do pole vsech stromu
//tzn. vytvorime vsechny kombinace, ktere lze vytvorit pridanim 1 vrcholu
procedure AddOne();
var i,j,dest,strcnt:Integer;
begin
 strcnt := Stromy.Count;
 for i := 0 to strcnt-1 do
  begin
   for j := 0 to Stromy.Data[i]^.Vrcholy.Count-1 do
    begin
     //zkopirujeme strom
     CopyStrom(i,dest);

     if (Stromy.Data[dest]^.Vrcholy.Count >= _MAX_VRCHOL) then
      begin
       Writeln('ADDONE: prekrocen maximalni pocet vrcholu');
       Exit;
      end;
     if (Stromy.Data[dest]^.Vrcholy.Data[j]^.Childs.Count >= _MAX_CHILD) then
      begin
       Writeln('ADDONE: prekrocen maximalni pocet deti');
       Exit;
      end;

     //na vrchol j pridame dalsi vrchol
     Stromy.Data[dest]^.Vrcholy.Count := Stromy.Data[dest]^.Vrcholy.Count + 1;
     New(Stromy.Data[dest]^.Vrcholy.Data[Stromy.Data[dest]^.Vrcholy.Count-1]);

     //navazeme 1. smer
     Stromy.Data[dest]^.Vrcholy.Data[Stromy.Data[dest]^.Vrcholy.Count-1]^.Childs.Count := 1;
     Stromy.Data[dest]^.Vrcholy.Data[Stromy.Data[dest]^.Vrcholy.Count-1]^.Childs.Data[0] := Stromy.Data[dest]^.Vrcholy.Data[j];

     //navazeme 2. smer
     Stromy.Data[dest]^.Vrcholy.Data[j]^.Childs.Count := Stromy.Data[i]^.Vrcholy.Data[j]^.Childs.Count + 1;
     Stromy.Data[dest]^.Vrcholy.Data[j]^.Childs.Data[Stromy.Data[dest]^.Vrcholy.Data[j]^.Childs.Count-1] := Stromy.Data[dest]^.Vrcholy.Data[Stromy.Data[dest]^.Vrcholy.Count-1];
    end;//for j
  end;//for i

 //odmazeme puvodni stromy ze zacatku pole
 for i := 0 to strcnt-1 do FreeStrom(i);

 //zkopirujeme nove stromy na zacatek
 for i := 0 to Stromy.Count-strcnt-1 do Stromy.Data[i] := Stromy.Data[i+strcnt];

 //prebytek na konci nastavime na nil
 for i := Stromy.Count-strcnt to Stromy.Count-1 do Stromy.Data[i] := nil;

 Stromy.Count := Stromy.Count-strcnt;
end;//procedure

////////////////////////////////////////////////////////////////////////////////
//Funkce na hledani housenky a/nebo humra:

//rekurzivni funkce na pocitani poctu deti
//pokud ma vrchol vice deti, jejich pocty se scitaji
//pokud chceme zjistit pocet vrcholu v dane casti grafu, musime zavolat vcetne parametru parent, jinak spocita vzdy celkovy pocet vrcholu
function CountChild(vrchol:PTVrchol;parent:PTVrchol = nil):Cardinal;
var i:Integer;
begin
 Result := 1;
 for i := 0 to vrchol^.Childs.Count-1 do
  if (parent <> vrchol^.Childs.Data[i]) then
    Result := Result + CountChild(vrchol^.Childs.Data[i],vrchol);
end;//function

//prochzeni patere housenky
//tato funkce predpoklada na vstupu regulerni strom (resp. vrchol regulerniho stromu)
//tj. vsechny zpetne hrany jsou validne navazany
function ProjdiPater(havet_typ:byte; actual:PTVrchol; sender:PTVrchol = nil):boolean;
var i,more1cnt:Integer;
    more1:array [0..1] of PTVrchol;
 begin
  Result := true;
  more1cnt := 0;

  //najdeme deti, ktere maji hloubku > 1 v pripade housenky, > 2 v pripade humra
   for i := 0 to actual^.Childs.Count-1 do
    begin
     if (CountChild(actual^.Childs.Data[i],actual) > havet_typ) then
      begin
       if (more1cnt >= 2) then
        begin
//         writeln('Prilis mnoho pateri');
         Result := false;
         Exit;
        end;

       more1[more1cnt] := actual^.Childs.Data[i];
       more1cnt := more1cnt + 1;
      end;//if > 1
    end;//for j

  //a postupujeme dale az ke kraji patere
   for i := 0 to more1cnt-1 do
    begin
     if (more1[i] <> sender) then
      begin
       Result := ProjdiPater(havet_typ, more1[i], actual);
       if (not result) then Exit;     //v pripade dvou smeru a jednoho nevalidniho ukoncime hned
      end;//if more1[i] <> sender
    end;//for i
 end;//procedure

//hledani patere housenky
//navratouvou hodnotou je true, pokud je stonozka validni, false, pokud neni validni
function HledejPater(havet_typ:Byte; actual:PTVrchol; sender:PTVrchol = nil):boolean;
var i,more1cnt:Integer;
    more1:array [0..1] of PTVrchol;
begin
 Result := true;
 more1cnt := 0;

  //najdeme deti, ktere maji hloubku > 1 v pripade housenky, > 2 v pripade humra
 for i := 0 to actual^.Childs.Count-1 do
  begin
   if (CountChild(actual^.Childs.Data[i],actual) > havet_typ) then
    begin
     if (more1cnt >= 2) then
      begin
//       writeln('ProjdiPater: Prilis mnoho pateri');
       Result := false;
       Exit;
      end;

     more1[more1cnt] := actual^.Childs.Data[i];
     more1cnt := more1cnt + 1;
    end;//if > 1
  end;//for i

 case (more1cnt) of
  0:Exit; //povazujeme za validni strom
  1:if (more1[0] <> sender) then Result := HledejPater(havet_typ, more1[0], actual);  //pokud jen 1 smer ma > 1, tak postupujeme v tomto smeru
  2:Result := ProjdiPater(havet_typ, actual);    //pokud 2 smery, jsme na pateri, tudiz zavolame prochazeni patere
 end;//case
end;//procedure

//reseni zadani KSI:
procedure KSI();
var i:Integer;
    return:boolean;
begin
 for i := 0 to Stromy.Count-1 do
  begin
   return := HledejPater(_T_HOUSENKA,Stromy.Data[i]^.Vrcholy.Data[0]);
   if (return) then
    begin
     writeln('STROM ',Integer(Stromy.Data[i]),' : housenka');
    end else begin
     return := HledejPater(_T_HUMR,Stromy.Data[i]^.Vrcholy.Data[0]);
     if (return) then
       writeln('STROM ',Integer(Stromy.Data[i]),' : humr') else writeln('STROM ',Integer(Stromy.Data[i]),' : kerik');
    end;//else return
  end;//for i
end;//procedure

////////////////////////////////////////////////////////////////////////////////
//main:

begin
  try
    //tento program zjistuje, pri jakem minimalnim poctu vrcholu grafu je potreba kontrolovat, zda-li graf je, ci neni housenka
    //pod timto poctem se automaticky predpoklada, ze to housenka je
    Initialize();

    writeln('zadejte pocet vrcholu (3-11):');
    readln(vrch_cnt);
    writeln('Mnozim stromy: ',Stromy.Count);
    l := 0;
    while (l < (vrch_cnt-2)) do
     begin
      AddOne(); //prida 1 vrchol
      writeln(l+3,' vrcholu, ',Stromy.Count,' stromu');
      l := l + 1;
     end;

    writeln('kontroluji stromu: ',Stromy.Count);

    cnt_hous := 0;
    cnt_humr := 0;

    l := 0;
    while (l < Stromy.Count) do
     begin
      return := HledejPater(_T_HOUSENKA,Stromy.Data[l]^.Vrcholy.Data[0]);
      if (return) then
       begin
        cnt_hous := cnt_hous + 1;
        cnt_humr := cnt_humr + 1;
       end else begin
        return := HledejPater(_T_HUMR,Stromy.Data[l]^.Vrcholy.Data[0]);
        if (return) then cnt_humr := cnt_humr + 1;
       end;

      l := l + 1;
     end;

    writeln('kontrola probehla uspesne');

    writeln('havet  celkem  valid     %');
    writeln('HOUS:  ',Format('%6d',[Stromy.Count]),'  ',Format('%5d',[cnt_hous]),'  ',Format('%6.2f',[cnt_hous/Stromy.Count*100]));
    writeln('HUMR:  ',Format('%6d',[Stromy.Count]),'  ',Format('%5d',[cnt_humr]),'  ',Format('%6.2f',[cnt_humr/Stromy.Count*100]));

    writeln('Nicim pamet...');
    writeln('Pro ukonceni programu stisknete enter:');
    FreeData();

    readln;
  except
    on E:Exception do
     begin
      Writeln(E.Classname, ': ', E.Message);
      FreeData();
     end;
  end;
end.
